/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.api.recipes.barrel;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.api.recipes.barrel.BarrelRecipe;
import net.dries007.tfc.objects.inventory.ingredient.IIngredient;
import net.dries007.tfc.objects.inventory.ingredient.IngredientFluidItem;
import net.dries007.tfc.util.Helpers;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BarrelRecipeFluidMixing
extends BarrelRecipe {
    public BarrelRecipeFluidMixing(@Nonnull IIngredient<FluidStack> inputFluid, @Nonnull IngredientFluidItem inputStack, @Nullable FluidStack outputFluid, int duration) {
        super(inputFluid, inputStack, outputFluid, ItemStack.field_190927_a, duration);
    }

    @Override
    public boolean isValidInputInstant(ItemStack inputStack, @Nullable FluidStack inputFluid) {
        FluidStack inputStackFluid = FluidUtil.getFluidContained((ItemStack)inputStack);
        if (inputFluid != null && inputStackFluid != null) {
            return inputFluid.amount / this.inputFluid.getAmount() <= inputStackFluid.amount / this.inputStack.getAmount();
        }
        return false;
    }

    @Override
    @Nullable
    public FluidStack getOutputFluid(FluidStack inputFluid, ItemStack inputStack) {
        return super.getOutputFluid(inputFluid, inputStack);
    }

    @Override
    @Nonnull
    public List<ItemStack> getOutputItem(FluidStack inputFluid, ItemStack inputStack) {
        return Helpers.listOf(inputStack.func_77973_b().getContainerItem(inputStack));
    }

    @Override
    protected int getMultiplier(FluidStack inputFluid, ItemStack inputStack) {
        FluidStack inputStackFluid;
        if (this.isValidInput(inputFluid, inputStack) && (inputStackFluid = FluidUtil.getFluidContained((ItemStack)inputStack)) != null) {
            return Math.min(inputFluid.amount / this.inputFluid.getAmount(), inputStackFluid.amount / this.inputStack.getAmount());
        }
        return 0;
    }
}

